/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.scope;

import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsolePerformer;
import filenet.sim.toolkit.console.VWSIMConsoleRootNode;
import filenet.sim.toolkit.console.VWSIMConsoleTreeCellRender;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.scope.VWSIMConsoleScopeViewPane;
import filenet.vw.base.VWDebug;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

class VWSIMConsoleScopeTree
extends JTree
implements TreeExpansionListener {
    private VWSIMBaseNode m_focus = null;
    private VWSIMConsolePerformer m_performer = null;
    private VWSIMConsoleScopeViewPane m_scopeViewPane = null;
    private boolean m_bSelectionActive = true;

    public VWSIMConsoleScopeTree(VWSIMConsoleRootNode root, VWSIMConsolePerformer performer, VWSIMConsoleScopeViewPane scopeViewPane) {
        super(root);
        this.m_focus = root;
        this.m_performer = performer;
        this.m_scopeViewPane = scopeViewPane;
        this.addTreeExpansionListener(this);
    }

    public boolean isSelectionActive() {
        return this.m_bSelectionActive;
    }

    public void setSelectionActive(boolean bActive) {
        if (bActive != this.m_bSelectionActive) {
            VWSIMConsoleTreeCellRender treeCellRender = (VWSIMConsoleTreeCellRender)this.getCellRenderer();
            treeCellRender.setSelectionActive(bActive);
            this.m_bSelectionActive = bActive;
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreePath selPath = event.getPath();
        VWSIMFolderNode fNode = (VWSIMFolderNode)selPath.getLastPathComponent();
        fNode.refreshSubFolderContents();
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    protected void refresh() {
        try {
            this.updateUI();
            this.setSelectionPath(new TreePath(this.m_focus.getPath()));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setFocus(VWSIMBaseNode node) {
        this.m_focus = node;
    }

    public void releaseResources() {
        this.m_focus = null;
        this.m_performer = null;
        this.m_scopeViewPane = null;
        this.removeTreeExpansionListener(this);
        this.removeAll();
    }
}

